/*
 * Decompiled with CFR 0.152.
 */
package pong;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import pong.Ball;
import pong.Mouse;
import pong.Player;

public class Game
extends JComponent {
    Mouse mouse = new Mouse();
    Ball ball = new Ball();
    Player player = new Player();
    Player enemy = new Player();
    double moveX = 5.0;
    double moveY = 5.0;
    int miliseccounter = 16;
    int pp = 0;
    private final Color WHITE = new Color(255, 255, 255);

    public Game() {
        this.addMouseMotionListener(this.mouse);
    }

    public void paintComponent(Graphics g) {
        this.drawBackground(g);
        this.drawBall(g, this.ball);
        this.drawPlayers(g, this.player, this.enemy);
        this.drawPoints(g, this.pp);
        this.player.setY(this.mouse.getMouseY());
        this.moveBall();
        this.enemyAI(this.enemy);
        this.repaint();
        this.fps();
    }

    private void drawBackground(Graphics g) {
        Graphics2D background = (Graphics2D)g;
        background.setColor(new Color(0, 0, 0));
        background.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    private void drawPoints(Graphics g, int pp) {
        g.setColor(new Color(255, 255, 255));
        g.setFont(new Font("Helvetica", 0, 24));
        g.drawString("Player : 0    Enemy : " + pp, this.getWidth() * 3 / 10, this.getHeight() / 12);
    }

    private void drawBall(Graphics g, Ball bally) {
        Graphics2D ball = (Graphics2D)g;
        ball.setColor(this.WHITE);
        ball.fillOval(bally.getX(), bally.getY(), bally.getHeight(), bally.getWidth());
    }

    private void drawPlayers(Graphics g, Player player, Player enemy) {
        this.drawPlayer(g, player);
        this.drawEnemy(g, enemy);
    }

    private void drawPlayer(Graphics g, Player play) {
        Graphics2D playerDraw = (Graphics2D)g;
        playerDraw.setColor(this.WHITE);
        playerDraw.fillRect(play.getX(), play.getY(), play.getWidth(), play.getHeight());
    }

    private void drawEnemy(Graphics g, Player enem) {
        Graphics2D enemyDraw = (Graphics2D)g;
        enemyDraw.setColor(this.WHITE);
        enemyDraw.fillRect(this.getWidth() - enem.getX() - 10, enem.getY(), enem.getWidth(), enem.getHeight());
    }

    private void moveBall() {
        if (this.ball.getX() > this.getWidth() || this.ball.getX() < 0) {
            this.moveX = -this.moveX;
            if (this.moveX > 0.0) {
                this.moveX += 0.5;
                this.speedUpY(this.moveY);
            } else {
                this.moveX += -0.5;
                this.speedUpY(this.moveY);
            }
        }
        if (this.ball.getY() > this.getHeight() || this.ball.getY() < 0) {
            this.moveY = -this.moveY;
        }
        this.ball.setX((int)((double)this.ball.getX() + this.moveX));
        this.ball.setY((int)((double)this.ball.getY() + this.moveY / 2.0));
        if (this.ball.getX() <= 0 && (this.ball.getY() <= this.player.getY() || this.ball.getY() >= this.player.getY() + this.player.getHeight())) {
            ++this.pp;
            this.reset();
        }
    }

    public double speedUpY(double moveY) {
        if (moveY > 0.0) {
            return moveY += 0.4;
        }
        return moveY += -0.4;
    }

    private void enemyAI(Player enem) {
        enem.setY(this.ball.getY() - (int)((double)enem.getHeight() / 2.0));
        if (enem.getY() < 0) {
            enem.setY(0);
        } else if (this.getHeight() < enem.getY()) {
            enem.setY(this.getHeight() - enem.getHeight());
        }
    }

    private void reset() {
        this.moveX = 5.0;
        this.moveY = 5.0;
        this.ball.setX(this.getWidth() / 2);
        this.ball.setY(this.getHeight() / 2);
    }

    private void fps() {
        try {
            Thread.sleep(this.miliseccounter);
        }
        catch (Exception exp) {
            System.out.println("Error Pong #1");
        }
    }
}

