/*
 * Decompiled with CFR 0.152.
 */
package javablast;

import gameMenu.HighScores;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import javablast.Bullets;
import javablast.Character;
import javablast.Collision;
import javablast.Controls;
import javablast.Enemy;
import javablast.Logic;
import javablast.StaticVariables;
import javablast.Wav;
import javax.swing.JComponent;

public class Game
extends JComponent {
    Character anajrobChar = new Character();
    int bulletDmg = StaticVariables.bulletDmg;
    Collision test = new Collision();
    Logic logic = new Logic();
    Controls contr = new Controls();
    HighScores hsinstance = new HighScores();
    int stage = 1;
    boolean win = false;
    boolean callHighScores = true;
    int devisor = 1;
    int speedRefreshRate = 7;
    int counter = 0;
    int bulletCount = StaticVariables.bulletCount;
    int currentBullet = StaticVariables.currentBullet;
    Bullets[] bullArray = new Bullets[this.bulletCount];
    static boolean gameover = false;
    static int enemyNumber = StaticVariables.enemyNumber;
    final int enemyNumberOriginal = enemyNumber;
    Enemy[] enemyArray = new Enemy[this.enemyNumberOriginal];
    int imageSxAnajrob = 0;
    int imageSyAnajrob = 0;
    int miliseccounter = 16;
    boolean bulletDirection = true;
    Image fg = StaticVariables.foreground;
    Image bg = StaticVariables.background;
    Image anajrob = Toolkit.getDefaultToolkit().getImage("standing right.png");
    Image anajrobStandL = Toolkit.getDefaultToolkit().getImage("standing left.png");
    Image anajrobStandR = Toolkit.getDefaultToolkit().getImage("standing right.png");
    Image anajrobRunL = Toolkit.getDefaultToolkit().getImage("running left.png");
    Image anajrobRunR = Toolkit.getDefaultToolkit().getImage("running right.png");
    Image anajrobStandUpL = Toolkit.getDefaultToolkit().getImage("standing up left.png");
    Image anajrobStandUpR = Toolkit.getDefaultToolkit().getImage("standing up right.png");
    Image anajrobRunUpL = Toolkit.getDefaultToolkit().getImage("running up left.png");
    Image anajrobRunUpR = Toolkit.getDefaultToolkit().getImage("running up right.png");
    Image anajrobDuckL = Toolkit.getDefaultToolkit().getImage("duck left.png");
    Image anajrobDuckR = Toolkit.getDefaultToolkit().getImage("duck right.png");
    Image anajrobJumpDownL = Toolkit.getDefaultToolkit().getImage("jump down left.png");
    Image anajrobJumpDownR = Toolkit.getDefaultToolkit().getImage("jump down right.png");
    Image bulletImageH = Toolkit.getDefaultToolkit().getImage("12px-blue-round-H.png");
    Image bulletImageV = Toolkit.getDefaultToolkit().getImage("12px-blue-round-V.png");
    Image enemyImageL = Toolkit.getDefaultToolkit().getImage("enemyL.png");
    Image enemyImageR = Toolkit.getDefaultToolkit().getImage("enemyR.png");
    Image[] bulletImage = new Image[this.bulletCount];
    Image[] enemyImage = new Image[enemyNumber];

    public Game() {
        this.setLayout(null);
        this.reset();
        for (int i = 0; i < this.bulletCount; ++i) {
            this.bullArray[i] = new Bullets(this.bulletDmg);
            this.bulletImage[i] = this.bulletImageH;
            if (i >= enemyNumber) continue;
            this.enemyArray[i] = new Enemy();
            this.enemyImage[i] = this.enemyImageL;
        }
        this.addKeyListener(this.contr);
        this.setFocusable(true);
    }

    public void paintComponent(Graphics g) {
        ++this.counter;
        this.drawGame(g);
        this.drawPoints(g);
        this.drawPlayerHP(g);
        this.drawEnemyHP(g);
        this.repaint();
        if (!gameover) {
            this.setRefreshRate();
            this.poziviMetoda();
        } else {
            this.drawGameOver(g);
            if (this.callHighScores) {
                this.callHighScores = false;
                this.hsinstance.writeIt(StaticVariables.points, this.stage);
            }
        }
        this.submitBulletCollision();
        this.submitCharacterCollision();
        this.enemyCourse();
        try {
            Thread.sleep(this.miliseccounter);
        }
        catch (Exception exp) {
            System.out.println("Error #1");
        }
        this.readImages();
        if (this.win) {
            this.win(g);
        }
        this.contr.setOldKeys();
    }

    public void drawGame(Graphics g) {
        int i;
        g.drawImage(this.bg, 0, 0, 960, 540, 0, 0, 960, 540, this);
        g.drawImage(this.anajrob, this.anajrobChar.getImageDxAnajrob(), this.anajrobChar.getImageDyAnajrob(), this.anajrobChar.getImageDxAnajrob() + 64, this.anajrobChar.getImageDyAnajrob() + 64, this.imageSxAnajrob, this.imageSyAnajrob, this.imageSxAnajrob + 64, this.imageSyAnajrob + 64, this);
        for (i = 0; i < this.bulletCount; ++i) {
            g.drawImage(this.bulletImage[i], this.bullArray[i].getX(), this.bullArray[i].getY(), this.bullArray[i].getX() + 12, this.bullArray[i].getY() + 12, 0, 0, 12, 12, this);
        }
        g.drawImage(this.fg, 0, 0, 960, 540, 0, 0, 960, 540, this);
        for (i = 0; i < enemyNumber; ++i) {
            g.drawImage(this.enemyImage[i], this.enemyArray[i].getX(), this.enemyArray[i].getY(), this.enemyArray[i].getX() + 102, this.enemyArray[i].getY() + 64, 0, 0, 102, 64, this);
        }
    }

    public void drawPoints(Graphics g) {
        g.setFont(new Font("Helvetica", 0, 25));
        g.setColor(new Color(50, 50, 255));
        g.drawString("Poeni: " + StaticVariables.points, 420, 20);
        g.setFont(new Font("Helvetica", 0, 20));
        g.setColor(new Color(255, 255, 255));
        g.drawString("Nivo: " + this.stage, 440, 40);
    }

    public void drawWin(Graphics g) {
        g.setFont(new Font("Helvetica", 0, 45));
        g.setColor(new Color(0, 0, 140));
        g.drawString("Level Complete", 320, 240);
        g.setFont(new Font("Helvetica", 0, 15));
        g.setColor(new Color(255, 255, 255));
        g.drawString("Pritisnite N za sledeci nivo", 380, 280);
    }

    public void drawPlayerHP(Graphics g) {
        g.setFont(new Font("Helvetica", 0, 12));
        g.setColor(new Color(255 - this.anajrobChar.getHealth(), this.anajrobChar.getHealth(), 0));
        g.fillRect(5, 10, this.anajrobChar.getHealth(), 15);
        g.setColor(new Color(0, 0, 0));
        g.drawRect(5, 10, 255, 15);
        g.drawString(StaticVariables.ime, 10, 22);
    }

    public void drawEnemyHP(Graphics g) {
        g.setFont(new Font("Helvetica", 0, 12));
        for (int i = 0; i < enemyNumber; ++i) {
            g.setColor(new Color(255 - this.enemyArray[i].getHealth(), this.enemyArray[i].getHealth(), 0));
            g.fillRect(700, 10 + i * 20, this.enemyArray[i].getHealth(), 15);
            g.setColor(new Color(0, 0, 0));
            g.drawRect(700, 10 + i * 20, 255, 15);
            int temp = StaticVariables.enemyCount + i;
            g.drawString("Alien " + temp, 705, 22 + i * 20);
        }
    }

    public void drawGameOver(Graphics g) {
        g.setFont(new Font("Helvetica", 0, 45));
        g.setColor(new Color(140, 0, 0));
        g.drawString("GAME OVER", 360, 240);
        g.setFont(new Font("Helvetica", 0, 12));
        g.setColor(new Color(0, 0, 0));
        g.drawString("Izadjite iz ovog prozora da se vratite do menia", 380, 260);
    }

    public void submitBulletCollision() {
        for (int i = 0; i < this.bulletCount; ++i) {
            for (int j = 0; j < enemyNumber; ++j) {
                this.test.testBulletCollision(this.bullArray[i], this.enemyArray[j]);
            }
        }
    }

    public void submitCharacterCollision() {
        for (int i = 0; i < enemyNumber; ++i) {
            this.test.testCharacter(this.anajrobChar, this.enemyArray[i]);
        }
        this.anajrobChar.setHit(false);
    }

    public void setRefreshRate() {
        if (this.counter % this.devisor == 0) {
            this.imageSxAnajrob += 64;
        }
        if (this.imageSxAnajrob >= 512 && (this.anajrob == this.anajrobRunL || this.anajrob == this.anajrobRunR || this.anajrob == this.anajrobRunUpL || this.anajrob == this.anajrobRunUpR) || this.imageSxAnajrob >= 320 && (this.anajrob == this.anajrobStandL || this.anajrob == this.anajrobStandR || this.anajrob == this.anajrobStandUpL || this.anajrob == this.anajrobStandUpR || this.anajrob == this.anajrobDuckL || this.anajrob == this.anajrobDuckR) || this.imageSxAnajrob >= 64 && (this.anajrob == this.anajrobJumpDownL || this.anajrob == this.anajrobJumpDownR)) {
            this.imageSxAnajrob = 0;
        }
    }

    public void readImages() {
        this.imagesLeft();
        this.imagesRight();
        this.imagesDown();
        this.imagesRun();
    }

    public void imagesLeft() {
        if (this.anajrobChar.getAnajrob().equals("standing left")) {
            this.anajrob = this.anajrobStandL;
            this.devisor = this.speedRefreshRate * 2;
            if (this.anajrobChar.getJumpState() == 1) {
                this.imageSxAnajrob = 192;
            }
        }
        if (this.anajrobChar.getAnajrob().equals("running left")) {
            this.anajrob = this.anajrobRunL;
            this.devisor = this.speedRefreshRate;
            if (this.anajrobChar.getJumpState() == 1) {
                this.imageSxAnajrob = 192;
            }
        }
        if (this.anajrobChar.getAnajrob().equals("standing up left")) {
            this.anajrob = this.anajrobStandUpL;
            this.devisor = this.speedRefreshRate * 2;
            if (this.anajrobChar.getJumpState() == 1) {
                this.imageSxAnajrob = 192;
            }
        }
        if (this.anajrobChar.getAnajrob().equals("running up left")) {
            this.anajrob = this.anajrobRunUpL;
            this.devisor = this.speedRefreshRate;
            if (this.anajrobChar.getJumpState() == 1) {
                this.imageSxAnajrob = 192;
            }
            if (this.anajrobChar.getImageDxAnajrob() == 0) {
                this.anajrob = this.anajrobStandUpL;
                this.devisor = this.speedRefreshRate * 2;
            }
        }
    }

    public void imagesRight() {
        if (this.anajrobChar.getAnajrob().equals("standing right")) {
            this.anajrob = this.anajrobStandR;
            this.devisor = this.speedRefreshRate * 2;
            if (this.anajrobChar.getJumpState() == 1) {
                this.imageSxAnajrob = 256;
            }
        }
        if (this.anajrobChar.getAnajrob().equals("running right")) {
            this.anajrob = this.anajrobRunR;
            this.devisor = this.speedRefreshRate;
            if (this.anajrobChar.getJumpState() == 1) {
                this.imageSxAnajrob = 256;
            }
        }
        if (this.anajrobChar.getAnajrob().equals("standing up right")) {
            this.anajrob = this.anajrobStandUpR;
            this.devisor = this.speedRefreshRate * 2;
            if (this.anajrobChar.getJumpState() == 1) {
                this.imageSxAnajrob = 256;
            }
        }
        if (this.anajrobChar.getAnajrob().equals("running up right")) {
            this.anajrob = this.anajrobRunUpR;
            this.devisor = this.speedRefreshRate;
            if (this.anajrobChar.getJumpState() == 1) {
                this.imageSxAnajrob = 256;
            }
            if (this.anajrobChar.getImageDxAnajrob() == 896) {
                this.anajrob = this.anajrobStandUpR;
                this.devisor = this.speedRefreshRate * 2;
            }
        }
    }

    public void imagesDown() {
        if (this.anajrobChar.getAnajrob().equals("duck left")) {
            this.anajrob = this.anajrobDuckL;
            this.devisor = this.speedRefreshRate * 2;
        }
        if (this.anajrobChar.getAnajrob().equals("duck right")) {
            this.anajrob = this.anajrobDuckR;
            this.devisor = this.speedRefreshRate * 2;
        }
        if (this.anajrobChar.getAnajrob().equals("jump down left")) {
            this.anajrob = this.anajrobJumpDownL;
            this.devisor = this.speedRefreshRate * 2;
        } else if (this.anajrobChar.getAnajrob().equals("jump down right")) {
            this.anajrob = this.anajrobJumpDownR;
            this.devisor = this.speedRefreshRate * 2;
        }
    }

    public void imagesRun() {
        if ((this.anajrobChar.isDashR() || this.anajrobChar.isDashL()) && (this.anajrobChar.getAnajrob().equals("running up left") || this.anajrobChar.getAnajrob().equals("running up right") || this.anajrobChar.getAnajrob().equals("running left") || this.anajrobChar.getAnajrob().equals("running right")) && this.anajrobChar.getImageDxAnajrob() != 0 && this.anajrobChar.getImageDxAnajrob() != 896) {
            this.devisor = this.speedRefreshRate / 2;
        }
    }

    public void enemyCourse() {
        for (int i = 0; i < enemyNumber; ++i) {
            this.enemyImage[i] = this.enemyArray[i].isCourseL() ? this.enemyImageL : this.enemyImageR;
        }
    }

    public void poziviMetoda() {
        this.logic.characterKretanje(this.anajrobChar, this.contr);
        this.logic.bulletKretanje(this.bullArray, this.bulletCount);
        this.logic.enemyKretanje(this.enemyArray, enemyNumber);
        this.win = this.logic.winState(this.enemyArray, enemyNumber);
        this.bulletMethod();
    }

    public void bulletMethod() {
        if (this.contr.isKeyX() && !this.contr.isKeyXOld()) {
            new Wav("1.wav").start();
            this.currentBullet = this.currentBullet < this.bulletCount - 1 ? ++this.currentBullet : 0;
            this.bulletDirection = this.bullArray[this.currentBullet].bulletSetup(this.anajrobChar.getImageDxAnajrob(), this.anajrobChar.getImageDyAnajrob());
            this.bulletImage[this.currentBullet] = this.bulletDirection ? this.bulletImageH : this.bulletImageV;
        }
    }

    public void win(Graphics g) {
        this.drawWin(g);
        if (this.contr.isKeyN()) {
            this.logic.nextLevel(this.stage);
            this.resetLevel();
        }
    }

    public void resetLevel() {
        this.anajrobChar.setImageDxAnajrob(150);
        this.anajrobChar.setImageDyAnajrob(300);
        this.win = false;
        this.callHighScores = true;
        for (int i = 0; i < enemyNumber; ++i) {
            this.enemyArray[i].resetEnemy();
        }
    }

    public void reset() {
        gameover = false;
        this.stage = 1;
    }
}

