/*
 * Decompiled with CFR 0.152.
 */
package javablast;

import javablast.Bullets;
import javablast.Character;
import javablast.Enemy;
import javablast.Game;
import javablast.StaticVariables;
import javablast.Wav;

public class Collision {
    int dmg = 1;
    int offsetY = 10;

    public void testBulletCollision(Bullets bullet, Enemy enemy) {
        if (bullet.getX() > enemy.getX() && bullet.getX() < enemy.getX() + enemy.getWidth() && bullet.getY() > enemy.getY() && bullet.getY() < enemy.getY() + enemy.getHeight()) {
            bullet.setX(-100);
            bullet.setY(-100);
            new Wav("hit.wav").start();
            if (enemy.getHealth() - bullet.getBulletDamage() >= 0) {
                enemy.setHealth(enemy.getHealth() - bullet.getBulletDamage());
                StaticVariables.points += (long)(bullet.getBulletDamage() * StaticVariables.pointMultiplier);
            } else {
                enemy.setHealth(0);
                enemy.setDead(true);
                new Wav("explosion.wav").start();
            }
        }
    }

    public void testCharacter(Character anajrobChar, Enemy enemy) {
        if (this.collisionAll(anajrobChar, enemy)) {
            this.reduceHpPlayer();
            if (this.collisionUnder(anajrobChar, enemy)) {
                anajrobChar.setJumpSpeed(-2.0);
            } else if (this.collisionSide(anajrobChar, enemy)) {
                anajrobChar.setImageDxAnajrob(enemy.getX());
            } else if (this.collisionAbove(anajrobChar, enemy)) {
                anajrobChar.setImageDyAnajrob(enemy.getY() - enemy.getHeight());
                anajrobChar.setHit(true);
                anajrobChar.setJumpState(2);
                anajrobChar.setJumpSpeed(11.0);
            }
        } else if (anajrobChar.getJumpState() == 2 && !anajrobChar.isHit()) {
            anajrobChar.setJumpState(1);
            anajrobChar.setJumpSpeed(0.0);
        }
    }

    private boolean collisionAll(Character anajrobChar, Enemy enemy) {
        return this.collisionX(anajrobChar, enemy) && anajrobChar.getImageDyAnajrob() < enemy.getY() + enemy.getHeight() && anajrobChar.getImageDyAnajrob() + anajrobChar.getHeight() > enemy.getY();
    }

    private boolean collisionUnder(Character anajrobChar, Enemy enemy) {
        return this.collisionX(anajrobChar, enemy) && anajrobChar.getImageDyAnajrob() < enemy.getY() + enemy.getHeight() && anajrobChar.getImageDyAnajrob() + anajrobChar.getHeight() > enemy.getY() + enemy.getHeight();
    }

    private boolean collisionSide(Character anajrobChar, Enemy enemy) {
        return this.collisionX(anajrobChar, enemy) && anajrobChar.getImageDyAnajrob() == enemy.getY();
    }

    private boolean collisionAbove(Character anajrobChar, Enemy enemy) {
        return (anajrobChar.getImageDyAnajrob() + anajrobChar.getHeight() < enemy.getY() + this.offsetY || anajrobChar.getImageDyAnajrob() + anajrobChar.getHeight() > enemy.getY() - this.offsetY) && this.collisionX(anajrobChar, enemy);
    }

    private boolean collisionX(Character anajrobChar, Enemy enemy) {
        return anajrobChar.getImageDxAnajrob() + anajrobChar.getWidth() > enemy.getX() && anajrobChar.getImageDxAnajrob() < enemy.getX() + enemy.getWidth();
    }

    public void reduceHpPlayer() {
        if (Character.health - this.dmg >= 0) {
            Character.health -= this.dmg;
            StaticVariables.points += (long)(this.dmg * StaticVariables.pointMultiplier);
        } else {
            Game.gameover = true;
        }
    }
}

