/*
 * Decompiled with CFR 0.152.
 */
package breakout;

import breakout.Ball;
import breakout.Blocks;
import breakout.Collision;
import breakout.Mouse;

public class Logic {
    Collision coll = new Collision();
    Mouse mouse = new Mouse();
    private int blockNumber = 100;
    private Blocks[] blocks = new Blocks[this.blockNumber];
    Blocks player = new Blocks();
    private Ball ball;
    int lives = 3;
    int screenWidth;
    int screenHeight;

    public Logic(int screenWidth, int screenHeight) {
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.setUpBall();
        this.setUpPlayer();
        this.setUpBlocks();
    }

    public Mouse getMouse() {
        return this.mouse;
    }

    public Blocks getBlocks(int number) {
        return this.blocks[number];
    }

    public Ball getBall() {
        return this.ball;
    }

    public Blocks getPlayer() {
        return this.player;
    }

    public int getBlockNumber() {
        return this.blockNumber;
    }

    public int getLives() {
        return this.lives;
    }

    public void loop() {
        this.collision();
        this.moveBall();
        this.movePlayer();
    }

    private void moveBall() {
        this.ball.setX(this.ball.getX() + this.ball.getMoveV());
        this.ball.setY(this.ball.getY() - this.ball.getMoveH());
    }

    private void collision() {
        this.block();
        this.wall();
        this.top();
        this.gameover();
    }

    private void block() {
        for (int j = 0; j < this.blockNumber; ++j) {
            if (!this.blocks[j].isEnabled() || !this.coll.checkCollisionBlock(this.blocks[j], this.ball)) continue;
            this.blocks[j].setEnabled(false);
            this.ball.changeCourseH();
            this.ball.speedUp();
        }
    }

    private void wall() {
        if (this.coll.checkCollisionWall(this.ball, this.screenWidth)) {
            this.ball.changeCourseV();
        }
    }

    private void top() {
        if (this.coll.checkCollisionTop(this.ball)) {
            this.ball.changeCourseH();
        }
    }

    private void gameover() {
        if (this.coll.gameoverRight(this.player, this.ball)) {
            this.ball.changeCourseH();
            this.ball.changeCourseRight();
        } else if (this.coll.gameoverLeft(this.player, this.ball)) {
            this.ball.changeCourseH();
            this.ball.changeCourseLeft();
        } else if (this.coll.collisionDown(this.ball, this.screenHeight)) {
            this.ball.setDead(true);
            --this.lives;
            if (this.lives == 0) {
                this.ball.setDeadAll(true);
            }
        }
    }

    private void movePlayer() {
        this.player.setX(this.mouse.getMouseX() - this.player.getWidth() / 2);
        if (this.player.getX() < 0) {
            this.player.setX(0);
        } else if (this.player.getX() + this.player.getWidth() > this.screenWidth) {
            this.player.setX(this.screenWidth - this.player.getWidth());
        }
        if (this.ball.isDead()) {
            this.ball.setX(this.player.getX() - this.ball.getWidth() / 2 + this.player.getWidth() / 2);
            this.ball.setY(this.screenHeight - 4 * this.ball.getHeight());
            if (this.mouse.isMouseClick()) {
                this.ball.launch(this.player.getX() - this.ball.getWidth() / 2 + this.player.getWidth() / 2, this.screenHeight - 4 * this.ball.getHeight());
                this.ball.setDead(false);
                this.mouse.setMouseClick(false);
            }
        }
    }

    private void setUpBall() {
        this.ball = new Ball(this.screenWidth / 2, this.screenHeight / 2);
    }

    public void setUpPlayer() {
        this.player.setY(760);
        this.player.setHeight(10);
        this.player.setWidth(100);
    }

    private void setUpBlocks() {
        int counter = 0;
        int j = 100;
        while (true) {
            for (int i = 0; i < this.screenWidth && counter < this.blockNumber; ++counter, i += 60) {
                this.blocks[counter] = new Blocks(i, j);
            }
            if (counter == this.blockNumber) break;
            j += 20;
        }
    }
}

