/*
 * Decompiled with CFR 0.152.
 */
package breakout;

import breakout.Logic;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;

public class Game
extends JComponent {
    Logic logic = new Logic(600, 800);
    private int miliseccounter = 16;

    public Game() {
        this.addMouseListener(this.logic.getMouse());
        this.addMouseMotionListener(this.logic.getMouse());
    }

    public void paintComponent(Graphics g) {
        Graphics2D obj = (Graphics2D)g;
        this.drawBackground(g);
        this.drawBall(g, obj);
        this.drawPlayer(g, obj);
        this.drawBlocks(g, obj);
        this.drawGameOver(g);
        this.DrawLife(g, obj);
        this.logic.loop();
        this.repaint();
        this.fps();
    }

    private void drawBackground(Graphics g) {
        Graphics2D background = (Graphics2D)g;
        background.setColor(new Color(230, 230, 255));
        background.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public void drawBall(Graphics g, Graphics2D obj) {
        obj.setColor(Color.BLACK);
        obj.fillOval(this.logic.getBall().getX(), this.logic.getBall().getY(), this.logic.getBall().getWidth(), this.logic.getBall().getHeight());
    }

    public void drawPlayer(Graphics g, Graphics2D obj) {
        obj.setColor(Color.BLACK);
        obj.fillRect(this.logic.getPlayer().getX(), this.logic.getPlayer().getY(), this.logic.getPlayer().getWidth(), this.logic.getPlayer().getHeight());
    }

    public void drawBlocks(Graphics g, Graphics2D obj) {
        for (int i = 0; i < this.logic.getBlockNumber(); ++i) {
            if (!this.logic.getBlocks(i).isEnabled()) continue;
            if (i >= 0 && i < 20) {
                obj.setColor(Color.YELLOW);
            } else if (i >= 20 && i < 40) {
                obj.setColor(Color.RED);
            } else if (i >= 40 && i < 60) {
                obj.setColor(Color.BLUE);
            } else if (i >= 60 && i < 80) {
                obj.setColor(Color.GREEN);
            } else {
                obj.setColor(Color.ORANGE);
            }
            obj.fillRect(this.logic.getBlocks(i).getX(), this.logic.getBlocks(i).getY(), this.logic.getBlocks(i).getWidth(), this.logic.getBlocks(i).getHeight());
            obj.setColor(Color.BLACK);
            obj.drawRect(this.logic.getBlocks(i).getX(), this.logic.getBlocks(i).getY(), this.logic.getBlocks(i).getWidth(), this.logic.getBlocks(i).getHeight());
        }
    }

    public void DrawLife(Graphics g, Graphics2D obj) {
        int tempLives = this.logic.getLives();
        if (tempLives != 0 && tempLives != 1) {
            int i = this.getWidth() - 20;
            while (true) {
                obj.setColor(Color.BLACK);
                obj.fillOval(i, 10, 15, 15);
                if (--tempLives == 1) break;
                i -= 20;
            }
        }
    }

    public void drawGameOver(Graphics g) {
        if (this.logic.getBall().isDeadAll()) {
            this.drawBackgroundGameOver(g);
            g.setColor(new Color(255, 0, 0));
            g.setFont(new Font("Helvetica", 0, 42));
            g.drawString("Game Over", this.getWidth() / 3, this.getHeight() / 2);
        }
    }

    private void drawBackgroundGameOver(Graphics g) {
        Graphics2D background = (Graphics2D)g;
        background.setColor(new Color(0, 0, 0));
        background.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    private void fps() {
        try {
            Thread.sleep(this.miliseccounter);
        }
        catch (Exception exp) {
            System.out.println("Error Pong #1");
        }
    }
}

