--===============================================================================
--[[
Autor: Borjana Savnik 450

Elemental - AD360 projekat

Year: 2010

game.lua
]]
--===============================================================================


--===============================================================================
--===== Variables ========== --===============================================================================

-- random seed
math.randomseed(os.time())
-- check color text
checkColor = Color.new(255, 170, 170)
white = Color.new(255, 255, 255)
black = Color.new(0, 0, 0)
redColor = Color.new(150, 40, 40)
-- screen resoultion
Resolution = { width = 480, height = 272 }
-- backround image
backround = Image.load("Images\\background.png")
-- vertical line
imgLine = Image.createEmpty(2,272)
imgLine:clear(Color.new(112, 112, 112))

happyMeda1 = 7
oldControlsOver = Controls.read()

--====== Tile pictures ============
-- stone tiles
nullImage =  Image.createEmpty(20,20)
red = Image.load("Images\\fire.png")
green = Image.load("Images\\paper.png")
blue = Image.load("Images\\water.png")
-- alive tiles
redP = Image.load("Images\\fire.png")
greenP = Image.load("Images\\paper.png")
blueP = Image.load("Images\\water.png")

--[[
scoreImage = Image.createEmpty(50, 20)
scoreImage:clear(Color.new(80, 120, 30))

scoreImageBorder = Image.createEmpty(54, 24)
scoreImageBorder:clear(Color.new(40, 100, 10))
]]

scoreImage = Image.createEmpty(52, 20)
scoreImage:clear(Color.new(200, 230, 130))

scoreImageBorder = Image.createEmpty(54, 22)
scoreImageBorder:clear(Color.new(112, 112, 112))

gameOverImage = Image.createEmpty(108, 48)
gameOverImage:clear(Color.new(80, 120, 30))

gameOverImageBorder = Image.createEmpty(112, 52)
gameOverImageBorder:clear(Color.new(40, 100, 10))

NextTileImage = Image.createEmpty(57, 20)
NextTileImage:clear(Color.new(200, 230, 130))

NextTileImageBorder = Image.createEmpty(59, 22)
NextTileImageBorder:clear(Color.new(112, 112, 112))

levelImage = Image.createEmpty(50, 20)
levelImage:clear(Color.new(80, 120, 30))

levelImageBorder = Image.createEmpty(54, 24)
levelImageBorder:clear(Color.new(40, 100, 10))

--====== Tile array ============

-- tile settings
tileWidth = 20
tileHeight = 20
xPos = 39
yPos = -20
tileData = {nullImage, red, green, blue, redP, greenP, blueP}
-- game map array
gameMap = {}
-- number of rows and columns
maxRow = 13
minRow = 1
maxCol = 6
minCol = 1

-- fps
--updateTime = 40
i = 0

pointsUpdate = 10
pointsAdd = pointsUpdate

--====== Locks ============
generate = false

firstBuffer = {math.random(5,7), math.random(5,7), math.random(5,7)}
secondBuffer = {math.random(5,7), math.random(5,7), math.random(5,7)}
buffer1X = 180
buffer1Y = 4

running = true
stop = false

gameOverMenu = Image.load("Images\\menu_game_over.png")
highScore = Image.load("Images\\highscore.png")
pauseMenu = Image.load("Images\\menu_pause.png")

resumeX = 75
resumeY = 130
restartX = 70
restartY = 150
quitX = 83
quitY = 170

quitQX = 75
quitQY = 130
restartQX = 70
restartQY = 150

selectorP = {image = selectionImage[math.random(1,3)], x = resumeX, y = resumeY }
selectorQ = {image = selectionImage[math.random(1,3)], x = quitQX, y = quitQY }
initialState = "resume"
state = initialState
stateOver = "restartQ"

newHighScore = false
writeHighScore = true

file = io.open("data.bri")
oldHighScore = file:read("*n")
file:close()

--===============================================================================
--====== Functions ============
--===============================================================================

-- draws tiles
function TileDraw()
xPos = 39
yPos = -20

for y = minRow,maxRow do
yPos = yPos + tileHeight
xPos = 39

for x = minCol,maxCol do
xPos = xPos + tileWidth

screen:blit(xPos,yPos, tileData[gameMap[y][x]])

screen:blit(buffer1X,buffer1Y - 1,NextTileImageBorder)
screen:blit(buffer1X+1,buffer1Y,NextTileImage)

screen:blit(buffer1X, buffer1Y, tileData[firstBuffer[1]])
screen:blit(buffer1X + tileWidth, buffer1Y, tileData[firstBuffer[2]])
screen:blit(buffer1X + tileWidth*2, buffer1Y, tileData[firstBuffer[3]])

screen:blit(buffer1X,buffer1Y + tileHeight * 1.5 - 1,NextTileImageBorder)
screen:blit(buffer1X+1,buffer1Y + tileHeight * 1.5,NextTileImage)

screen:blit(buffer1X, buffer1Y + tileHeight * 1.5, tileData[secondBuffer[1]])
screen:blit(buffer1X + tileWidth, buffer1Y + tileHeight * 1.5, tileData[secondBuffer[2]])
screen:blit(buffer1X + tileWidth*2, buffer1Y + tileHeight * 1.5, tileData[secondBuffer[3]])

end
end

end

-- draws backround and vertical line
function drawImages()
screen:blit(0,0,backround)
screen:blit(239,0,imgLine)
end

-- new game
function NewGame()
screen:clear()

newHighScore = false

--====== Locks ============
lock = false
skip = false
hyperlock = false
stop = false

points = 0
updateTime = 40
level = 1

--====== Game map array ============
gameMap[1] = {1, 1, 5, 6, 7, 1}
gameMap[2] = {1, 1, 1, 1, 1, 1}
gameMap[3] = {1, 1, 1, 1, 1, 1}
gameMap[4] = {1, 1, 1, 1, 1, 1}
gameMap[5] = {1, 1, 1, 1, 1, 1}
gameMap[6] = {1, 1, 1, 1, 1, 1}
gameMap[7] = {1, 1, 1, 1, 1, 1}
gameMap[8] = {1, 1, 1, 1, 1, 1}
gameMap[9] = {1, 1, 1, 1, 1, 1}
gameMap[10] = {1, 1, 1, 1, 1, 1}
gameMap[11] = {1, 1, 1, 1, 1, 1}
gameMap[12] = {1, 1, 1, 1, 1, 1}
gameMap[13] = {1, 1, 1, 1, 1, 1}

-- random tile
gameMap[1][3] = firstBuffer[1]
gameMap[1][4] = firstBuffer[2]
gameMap[1][5] = firstBuffer[3]
pointsAdd = pointsUpdate
end

-- moves tiles down
function TileMove()
for y = maxRow -1,minRow,-1 do
for x = maxCol,minCol,-1 do
if gameMap[y][x] > 4 and gameMap[y+1][x] == 1 then
gameMap[y+1][x] = gameMap[y][x]
gameMap[y][x] = 1
end
end
end
end

--===== Player Input ==========
function PlayerInput()
-- read controls
pad = Controls.read()

-- if down pressed
if pad:down() and pad ~=oldControls then
updateTime = 1
lock = true
end

-- if left presed
if pad:left() and pad ~=oldControls then		
	for y = maxRow -1,minRow,-1 do
	for x = minCol +1,maxCol do
	if gameMap[y][x] > 4 and gameMap[y][x-1] ~= 2 and gameMap[y][x-1] ~= 3 and gameMap[y][x-1] ~= 4 and lock == false then
	if (gameMap[y][x-1] == 1) then
	gameMap[y][x-1] = gameMap[y][x]
	gameMap[y][x] = 1
	end
	end
	end
	end
	
end

-- if right pressed
if pad:right() and pad ~=oldControls then
	
for y = maxRow -1,minRow,-1 do
for x = maxCol -1,minCol,-1 do
	if gameMap[y][x] > 4 and gameMap[y][x+1] ~= 2 and gameMap[y][x+1] ~= 3 and gameMap[y][x+1] ~= 4 and lock == false then
	if (gameMap[y][x + 1] == 1) then
		gameMap[y][x+1] = gameMap[y][x]
		gameMap[y][x] = 1
	end
	end
	end
	end
end


if not hyperlock then
-- if circle pressed
	if pad:circle() and pad ~=oldControls and eat == false then
	skip = false

	for y = maxRow,minRow,-1 do
	for x = maxCol,minCol,-1 do
		if gameMap[y][x] > 4 and not skip then
			temp = gameMap[y][x]
			gameMap[y][x] = gameMap[y][x-1]
			gameMap[y][x-1] = gameMap[y][x-2]
			gameMap[y][x-2] = temp		
			skip = true
		end
		end
		end

	end
-- if cross pressed
	if pad:cross() and pad ~=oldControls and eat == false then
	skip = false

	for y = maxRow,minRow,-1 do
	for x = maxCol,minCol,-1 do
		if gameMap[y][x] > 4 and not skip then
			temp = gameMap[y][x]
			gameMap[y][x] = gameMap[y][x-2]
			gameMap[y][x-2] = gameMap[y][x-1]
			gameMap[y][x-1] = temp
			skip = true
		end
		end
		end

	end
end

if pad:start() and pad ~=oldControls then
	--running = false
	stop = true
end

-- save last control
oldControls = pad
end

--===== Eat Check ==========
function EatCheck()
	eat = false
	for y = maxRow - 1,minRow,-1 do
	for x = maxCol,minCol,-1 do
-- water beats fire
	if gameMap[y][x] == 7 and gameMap[y+1][x] == 2 then
	gameMap[y][x] = 1
	gameMap[y+1][x] = 7
	points = points + pointsAdd
	pointsAdd = pointsAdd + pointsUpdate
	eat = true
	hyperlock = true
	return true
	end
-- paper beats water
	if gameMap[y][x] == 6 and gameMap[y+1][x] == 4 then
	gameMap[y][x] = 1
	gameMap[y+1][x] = 6
	points = points + pointsAdd
	pointsAdd = pointsAdd + pointsUpdate	
	eat = true
	hyperlock = true
	return true
	end
-- fire beats paper
	if gameMap[y][x] == 5 and gameMap[y+1][x] == 3 then
	gameMap[y][x] = 1
	gameMap[y+1][x] = 5
	points = points + pointsAdd
	pointsAdd = pointsAdd + pointsUpdate	
	eat = true
	hyperlock = true
	return true
	end
	
	end
	end

	return false

end
 
 --===== Collision Check ==========
 function CollisionCheck()
 -- if not eating
	if not EatCheck() then
 
	for y = maxRow,minRow,-1 do
	for x = maxCol,minCol,-1 do
	if y == maxRow and gameMap[y][x] > 4 then
		temp = gameMap[y][x]
		newTemp = temp - 3
		gameMap[y][x] = newTemp
		--hyperlock = true
	end
	if gameMap[y][x] > 4 and gameMap[y+1][x] > 1 and gameMap[y+1][x] < 5 then	
	temp = gameMap[y][x]
	newTemp = temp - 3
	gameMap[y][x] = newTemp
	lock = true
	hyperlock = true
	end
	end
	end
	
	end
end

function Pause()
if stop == true then
return true
end
return false
end

--===== Game Over ==========
function GameOver()
	for x = 3,5 do
		if gameMap[1][x] > 1 and gameMap[1][x] < 5 then
			return true
		end
	end
	return false
end

--===== Next Figure Check ==========
function NextFigureCheck()
	for y = maxRow -1,minRow,-1 do
	for x = maxCol,minCol,-1 do
	if gameMap[y][x] > 4 then
		generate = false
	end
	end
	end
	
end

--===== Next Figure ==========
function NextFigure()
	for y = maxRow -1,minRow,-1 do
	for x = maxCol,minCol,-1 do
	if gameMap[y][x] < 5 then	
	gameMap[1][3] = firstBuffer[1]
	gameMap[1][4] = firstBuffer[2]
	gameMap[1][5] = firstBuffer[3]	
	
	Ubrzanje()

	lock = false
	skip = false
	hyperlock = false
	pointsAdd = pointsUpdate
	end
	end
	end
	
	firstBuffer[1] = secondBuffer[1]
	firstBuffer[2] = secondBuffer[2]
	firstBuffer[3] = secondBuffer[3]
	
	secondBuffer[1] = math.random(5,7)
	secondBuffer[2] = math.random(5,7)
	secondBuffer[3] = math.random(5,7)
end

--===== Levels ==========
function Ubrzanje()
if points > 10000 then
updateTime = 5
level = 10
elseif points > 8000 then
updateTime = 8
level = 9
elseif points > 7000 then
updateTime = 11
level = 8
elseif points > 6000 then
updateTime = 14
level = 7
elseif points > 5000 then
updateTime = 18
level = 6
elseif points > 4000 then
updateTime = 22
level = 5
elseif points > 3000 then
updateTime = 26
level = 4
elseif points > 2000 then
updateTime = 30
level = 3
elseif points > 1000 then
updateTime = 35
level = 2
else
updateTime = 40
end

end

-- New Game
NewGame()
--===============================================================================
 --===== Main Loop ==========
 --===============================================================================
while running do
screen: clear()
-- draw backround and vertical line
drawImages()
-- next Figure


TileDraw()

-- points
screen:blit(2,4,levelImageBorder)
screen:blit(4,6,levelImage)
screen:print(6,13, "level" ..level, white)

screen:blit(2,32,levelImageBorder)
screen:blit(4,34,levelImage)
screen:print(6,41, "HScore", white)

screen:blit(2,53,scoreImageBorder)
screen:blit(3,54,scoreImage)
screen:print(6,61, oldHighScore, redColor)

screen:blit(2,80,scoreImageBorder)
screen:blit(3,81,scoreImage)
if newHighScore then
	screen:print(6, 88, points, redColor)
else
	screen:print(6, 88, points, black)
end

if points > oldHighScore then
	newHighScore = true;
	oldHighScore = points
end

--Pause menu
if Pause() then
	dofile("pause.lua")
else
	if not GameOver() then
		generate = true
		NextFigureCheck()
		if generate == true then
		NextFigure()
		end

		PlayerInput()
		CollisionCheck()
		
	-- tile movement
		i = i + 1
		if(i >= updateTime) and stop == false then
		i = 0
		TileMove()
		end
	end

	-- Game over text
	if GameOver() then
		if writeHighScore then
			dofile("fileWrite.lua")
			writeHighScore = false
		end
		dofile("gameOver.lua")
	end
end

-- standard
screen.waitVblankStart()
screen.flip()
end
